/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.lectern;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public class CustomLecternBlock
extends LecternBlock {
    private static final BlockEntityTicker<CustomLecternBlockEntity> serverTicker = (level, pos, state, lectern) -> lectern.tick();

    public CustomLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
    }

    public static InteractionResult tryPlaceItem(Player player, Level level, BlockPos pos, BlockState blockState, ItemStack item) {
        if (item.getItem() instanceof PrintoutItem || item.getItem() instanceof PocketComputerItem) {
            if (!level.isClientSide) {
                CustomLecternBlock.replaceLectern(player, level, pos, blockState, item);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static void replaceLectern(Player player, Level level, BlockPos pos, BlockState blockState, ItemStack item) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((CustomLecternBlock)((Object)ModRegistry.Blocks.LECTERN.get())).defaultBlockState().setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)((Direction)blockState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)blockState.getValue((Property)POWERED))));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity be = (CustomLecternBlockEntity)blockEntity;
            be.setItem(item.consumeAndReturn(1, (LivingEntity)player));
        }
    }

    static void clearLectern(Level level, BlockPos pos, BlockState blockState) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)Blocks.LECTERN.defaultBlockState().setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)blockState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)blockState.getValue((Property)POWERED))));
    }

    @Deprecated
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.LECTERN);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        CustomLecternBlockEntity lectern;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomLecternBlockEntity && (lectern = (CustomLecternBlockEntity)blockEntity).getItem().isEmpty()) {
            CustomLecternBlock.clearLectern((Level)level, pos, state);
            return;
        }
        super.tick(state, level, pos, random);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            CustomLecternBlock.dropItem(level, pos, state, lectern.getItem().copy());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private static void dropItem(Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        double dx = 0.25 * (double)direction.getStepX();
        double dz = 0.25 * (double)direction.getStepZ();
        ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5 + dx, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + dz, stack);
        entity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)entity);
    }

    public String getDescriptionId() {
        return Blocks.LECTERN.getDescriptionId();
    }

    public CustomLecternBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CustomLecternBlockEntity(pos, state);
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            n = lectern.getRedstoneSignal();
        } else {
            n = 0;
        }
        return n;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CustomLecternBlockEntity) {
            CustomLecternBlockEntity lectern = (CustomLecternBlockEntity)blockEntity;
            if (player.isSecondaryUseActive()) {
                CustomLecternBlock.clearLectern(level, pos, state);
            } else {
                lectern.openMenu(player);
            }
            player.awardStat(Stats.INTERACT_WITH_LECTERN);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BlockEntityHelpers.createTickerHelper(type, (BlockEntityType)ModRegistry.BlockEntities.LECTERN.get(), serverTicker);
    }
}

